/*
 *  Quadbike 2
 *  Copyright (C) 2026 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_UTIL_H
#define QB_UTIL_H

#include "quadbike.h"
#include "source.h"
#include "atom.h"



extern char qb_scprintf_dummy;

void qb_u32_to_little_endian (u32_t i, char buf[4]);

void qb_update_meter (u8_t display_progress,
                      s64_t pos,
                      s64_t len,
                      float fraction_of_total_job,
                      s32_t starting_percent);

//s32_t get_window_2_len (float window1_len); //, float window2_len, float sample_rate);

void qb_hide_meter (u8_t display_progress, u8_t newline);

void qb_show_meter (u8_t display_progress);

void *qb_malloc (size_t size);

void *qb_realloc(void *p, size_t size);

s16_t qb_double_to_s16 (double d);
s16_t qb_float_to_s16 (float f);

// only used for writing inspect file
void qb_normalise_powers (float *pwr0_inout,
                          float *pwr1_inout,
                          float maxX);

qb_err_t qb_test_rate_legal (s32_t sr);

void qb_free(void *p);

#ifdef QB_HAVE_ZLIB
qb_err_t qb_zlib_compress (u8_t *source,
                           size_t srclen,
                           u8_t use_gzip_encoding,
                           u8_t **dest,
                           size_t *destlen) ;
#endif

qb_err_t qb_make_fully_qualified_path (char *in, char **out, char *cwd);

qb_err_t qb_get_working_directory (char **out);

#ifdef QB_WINDOWS
qb_err_t qb_windows_convert_utf8_string_to_wchar(char *s, LPWSTR *out, int *len_out);
#endif

const char *qb_util_basename (const char *path);

#endif // QB_UTIL_H
