/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "bp_2k4_44k.h"

/*

FIR filter designed with
 http://t-filter.engineerjs.com

sampling frequency: 44100 Hz

* 0 Hz - 2000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -44.586149545175964 dB

* 2200 Hz - 2600 Hz
  gain = 1
  desired ripple = 12 dB
  actual ripple = 7.167117817814477 dB

* 2800 Hz - 22050 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -44.586149545175964 dB

*/

const double qb_fir_taps_bp_2k4_44k[QB_FIR_TAPS_BP_2K4_44K] = {
  0.0030430349307003684,
  0.00018034937234924533,
  0.00016698180550388437,
  0.00010036467990148697,
  -0.00006192972866357134,
  -0.00034769866208320674,
  -0.0007514692591592024,
  -0.0012254367280743505,
  -0.0016837205941967887,
  -0.0020194625358747405,
  -0.002130548971631962,
  -0.0019460538635555004,
  -0.001446947605303625,
  -0.0006739371683582701,
  0.00027716609536694125,
  0.0012733295133530254,
  0.002168383485871616,
  0.002828608162629925,
  0.0031533369086359886,
  0.0030874587776837078,
  0.002625049552019272,
  0.0018051911642498592,
  0.0007071504659850442,
  -0.0005673201972041403,
  -0.001887785039896617,
  -0.003115438272798385,
  -0.004106736620665099,
  -0.004724977743921568,
  -0.004855442141063827,
  -0.004423505777424918,
  -0.0034128418395530085,
  -0.0018794693264600584,
  0.000042654100638315297,
  0.0021485825316037146,
  0.004182417884326604,
  0.005870235163891702,
  0.006958136870733004,
  0.007252782247100984,
  0.006653914400500643,
  0.005175067673370813,
  0.0029476745184274403,
  0.00020825130615484644,
  -0.0027292028716078987,
  -0.005511759244237966,
  -0.007789681964691977,
  -0.009261579580568148,
  -0.009708077324664522,
  -0.009022533431036919,
  -0.007226391322043101,
  -0.004472146338351984,
  -0.0010324666029038977,
  0.0027240447499772085,
  0.006369379424589263,
  0.00946233045286579,
  0.011599985078917272,
  0.012469285420768373,
  0.01189149948838536,
  0.009855641566447025,
  0.006529090673333403,
  0.002249490692558916,
  -0.0025089069897527377,
  -0.007187995154337741,
  -0.01121295431631964,
  -0.014064705230653668,
  -0.015347894283748444,
  -0.014845476259800879,
  -0.012551066531511397,
  -0.008677230807460686,
  -0.0036339944453072518,
  0.0020147134104604135,
  0.007615462584424007,
  0.012501137468826529,
  0.016069995253176525,
  0.017858530148974514,
  0.017600070186298392,
  0.015262167153520464,
  0.011057705315569964,
  0.005427619054912,
  -0.0010057693501938244,
  -0.007501915650295527,
  -0.013292942523646758,
  -0.017671154145421794,
  -0.020078093469816916,
  -0.02017647129508548,
  -0.017897695219750705,
  -0.013457515906678413,
  -0.007336711880508965,
  -0.0002286765350076187,
  0.007041164958945826,
  0.013612631000083454,
  0.01869534541049652,
  0.021664537475931195,
  0.02213863437646569,
  0.02002758245886077,
  0.015546761831692547,
  0.009194203492653572,
  0.0016941591486761523,
  -0.006086264961268748,
  -0.013237561608144646,
  -0.018911444012659102,
  -0.02244467612200972,
  -0.023387889726686806,
  -0.021615486131752435,
  -0.01731307376809964,
  -0.0109667745194678,
  -0.003307496013603196,
  0.004773670879250978,
  0.012330175898572332,
  0.01847263771782559,
  0.022475400448868272,
  0.023864611862440148,
  0.022475400448868272,
  0.01847263771782559,
  0.012330175898572332,
  0.004773670879250978,
  -0.003307496013603196,
  -0.0109667745194678,
  -0.01731307376809964,
  -0.021615486131752435,
  -0.023387889726686806,
  -0.02244467612200972,
  -0.018911444012659102,
  -0.013237561608144646,
  -0.006086264961268748,
  0.0016941591486761523,
  0.009194203492653572,
  0.015546761831692547,
  0.02002758245886077,
  0.02213863437646569,
  0.021664537475931195,
  0.01869534541049652,
  0.013612631000083454,
  0.007041164958945826,
  -0.0002286765350076187,
  -0.007336711880508965,
  -0.013457515906678413,
  -0.017897695219750705,
  -0.02017647129508548,
  -0.020078093469816916,
  -0.017671154145421794,
  -0.013292942523646758,
  -0.007501915650295527,
  -0.0010057693501938244,
  0.005427619054912,
  0.011057705315569964,
  0.015262167153520464,
  0.017600070186298392,
  0.017858530148974514,
  0.016069995253176525,
  0.012501137468826529,
  0.007615462584424007,
  0.0020147134104604135,
  -0.0036339944453072518,
  -0.008677230807460686,
  -0.012551066531511397,
  -0.014845476259800879,
  -0.015347894283748444,
  -0.014064705230653668,
  -0.01121295431631964,
  -0.007187995154337741,
  -0.0025089069897527377,
  0.002249490692558916,
  0.006529090673333403,
  0.009855641566447025,
  0.01189149948838536,
  0.012469285420768373,
  0.011599985078917272,
  0.00946233045286579,
  0.006369379424589263,
  0.0027240447499772085,
  -0.0010324666029038977,
  -0.004472146338351984,
  -0.007226391322043101,
  -0.009022533431036919,
  -0.009708077324664522,
  -0.009261579580568148,
  -0.007789681964691977,
  -0.005511759244237966,
  -0.0027292028716078987,
  0.00020825130615484644,
  0.0029476745184274403,
  0.005175067673370813,
  0.006653914400500643,
  0.007252782247100984,
  0.006958136870733004,
  0.005870235163891702,
  0.004182417884326604,
  0.0021485825316037146,
  0.000042654100638315297,
  -0.0018794693264600584,
  -0.0034128418395530085,
  -0.004423505777424918,
  -0.004855442141063827,
  -0.004724977743921568,
  -0.004106736620665099,
  -0.003115438272798385,
  -0.001887785039896617,
  -0.0005673201972041403,
  0.0007071504659850442,
  0.0018051911642498592,
  0.002625049552019272,
  0.0030874587776837078,
  0.0031533369086359886,
  0.002828608162629925,
  0.002168383485871616,
  0.0012733295133530254,
  0.00027716609536694125,
  -0.0006739371683582701,
  -0.001446947605303625,
  -0.0019460538635555004,
  -0.002130548971631962,
  -0.0020194625358747405,
  -0.0016837205941967887,
  -0.0012254367280743505,
  -0.0007514692591592024,
  -0.00034769866208320674,
  -0.00006192972866357134,
  0.00010036467990148697,
  0.00016698180550388437,
  0.00018034937234924533,
  0.0030430349307003684
};
