/*
 *  Quadbike 2
 *  Copyright (C) 2026 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_TAPESPEED_H
#define QB_TAPESPEED_H

#include "quadbike.h"
#include "vector.h"

// measure within this range:
#define QB_TAPE_SPEED_SEARCH_MIN 0.75f
#define QB_TAPE_SPEED_SEARCH_MAX 1.25f

// then allow speeds within this range
#define QB_TAPE_SPEED_MIN 0.85f
#define QB_TAPE_SPEED_MAX 1.15f
                                              
u8_t qb_is_tape_speed_legal (float tape_speed);

#if defined QB_VECTORS_GCC_CLANG || defined QB_VECTORS_MSVC_AVX2
qb_err_t qb_span_measure_speed_vector  (s32_t rate,
                                     float *src_f, // scalar
                                     s64_t len,
                                     float freq_min,
                                     float freq_max,
                                     float freq_nominal,
                                     float *speed_out);
#else // no vectors
qb_err_t qb_span_measure_speed_scalar (s32_t rate,
                                       float *src_data,
                                       s64_t len,
                                       float freq_min,
                                       float freq_max,
                                       float freq_nominal, // unused
                                       float *speed_out);
#endif // no vectors

                                     
qb_err_t qb_span_measure_speed  (s32_t rate,
                                 float *src_data,
                                 s64_t len,
                                 float freq_min,
                                 float freq_max,
                                 float freq_nominal,
                                 float *speed_out);

//qb_err_t qb_serialise_tape_speeds (qb_span_t *spans,
//                                   s32_t num_spans,
//                                   u8_t **buf_out,
//                                   size_t *buflen_out);

#endif // QB_TAPESPEED_H
