/*
 *  Quadbike 2
 *  Copyright (C) 2026 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_SYNC_PLL_H
#define QB_SYNC_PLL_H

#include "quadbike.h"
#include "process.h"
#include "sync_walk.h"
#include "span.h"
#include "fir.h"
#include "pll.h"

#define QB_PLL_DELAY_SEARCH_NONE            0
#define QB_PLL_DELAY_SEARCH_BEST_WORST      1 // this mode appears to be worse than _CONFIDENCE_SUM, and is unused
#define QB_PLL_DELAY_SEARCH_CONFIDENCE_SUM  2

#define QB_PLL_DELAY_SEARCH_LOWER_BOUND    -3
#define QB_PLL_DELAY_SEARCH_UPPER_BOUND     3

// if overridden on command line, these are the limits:
#define QB_PLL_CARRIER_OFFSET_LOWER_BOUND -10
#define QB_PLL_CARRIER_OFFSET_UPPER_BOUND 10

// based closely on pll_span_get_cycs()
qb_err_t qb_pll_span_shift_search (float *carrier_signal,
                                   float *goertz[2],
                                    s64_t input_len,
                                    qb_span_t *leader_span,
                                    qb_span_t *data_span,
                                    u8_t reversed,
                                    s32_t sample_rate,
                                    qb_pll_t pll, // use a copy, so we don't disturb the PLL
                                    u8_t phase_ix,
                                    s8_t *best_delay_out,
                                    u8_t method) ;

qb_err_t qb_get_data_span_phases_by_pll (s64_t srclen,
                                         qb_span_t *spans,
                                         s32_t num_spans,
                                         s32_t rate,
                                         u8_t dp,     // display progress (percentage)
                                         u8_t silent, // 2.0.4: no output at all
                                         qb_pll_carrier_t carriers[4]);
                                              
qb_err_t qb_derive_sync_pll (s64_t full_len,
                             s32_t sample_rate,
                             qb_span_t *spans,
                             s32_t num_spans,
                             qb_pll_carrier_t carriers[4],
                             qb_inspect_t *inspect,
                             u8_t dp,        // display_progress, if true then print the updating percentage value
                             u8_t silent,    // if true, don't even display the "Extracting sync" label
                             u8_t verbose); // if true, maybe print some extra errors

qb_err_t qb_generate_pll_carrier_scalar  (float *buf_f,             // input
                                          float *buf_squared_f,     // pre-squared: ((v * v) * 2.0f) - 1.0f
                                          s64_t full_len,           // input length
                                          s64_t filter_delay,
                                          s8_t phase_shift_smps,
                                          u8_t phase_ix,
                                          //float clipping_level,      // 0.0 means ultra clip, 1.0 means no clip
                                          float *buf_carrier_clipped_out,
                                          qb_fir_t *bp_2k4_p,
                                          u8_t display_progress,
                                          qb_inspect_t *inspect);
                                  
                                  /*
qb_err_t pll_span_get_cycs (qb_pll_carrier_t *carrier,
                               s8_t best_pll_delay,
                               s64_t input_len,
                               s64_t span_len,    // span length
                               s64_t span_start_smps,
                               u8_t reversed,
                               s32_t sample_rate,
                               qb_pll_t *pll,
                               //double tape_speed,
                               //float tape_speed,
                               //float pll_phase_at_bit_transitions,
                               u8_t phase_ix,
                               // where the leader ends and where we want to start actually capturing data:
                               //s32_t span_ix, // for printing only
                               qb_atom_t **cycles_out, // or NULL
                               s32_t *num_cycles_out,   // or NULL
                               qb_inspect_t *inspect,
                               //double *lock_average_per_sample_out) {
                               float *lock_average_per_sample_out); */

#endif // QB_SYNC_PLL_H
