/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "bp_0k4_3k2_44k.h"

/*

FIR filter designed with
 http://t-filter.engineerjs.com

sampling frequency: 44100 Hz

* 0 Hz - 100 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -40.246787496280156 dB

* 400 Hz - 3200 Hz
  gain = 1
  desired ripple = 6 dB
  actual ripple = 5.020636945608186 dB

* 3600 Hz - 22050 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -40.246787496280156 dB

*/



const double qb_fir_taps_bp_0k4_3k2_44k[QB_FIR_TAPS_BP_0K4_3K2_44K] = {
  0.0076850586982215585,
  0.006747189330139785,
  0.008929881353988247,
  0.010906200637928992,
  0.012434291979888126,
  0.013311682305199985,
  0.013405673947750527,
  0.012674208091989657,
  0.01116759081169588,
  0.009015293138416742,
  0.006401142053577143,
  0.0035310396565683987,
  0.0006009668111083251,
  -0.002225542764886251,
  -0.004829221841616923,
  -0.007135018543169206,
  -0.009094681647916722,
  -0.010668885872912523,
  -0.011811590736777487,
  -0.012458130668497066,
  -0.012536903052289222,
  -0.01198293506324944,
  -0.010773546145437803,
  -0.008960167884861286,
  -0.00669484149235097,
  -0.004239409552378597,
  -0.0019441039818904025,
  -0.00020471254562582804,
  0.0006070503306512682,
  0.00022081053185576111,
  -0.0014601365677881048,
  -0.004307968814918238,
  -0.007962082298390447,
  -0.011866903363934905,
  -0.015357067833173548,
  -0.017776983899015067,
  -0.018612629075524217,
  -0.0176107407498343,
  -0.014858461079284142,
  -0.010801475204181246,
  -0.006187586889156906,
  -0.001937853833798161,
  0.0010122082843755109,
  0.0019363448254255903,
  0.0004293092083268547,
  -0.0034023785637388036,
  -0.00898922374254505,
  -0.015340390238210138,
  -0.021209081875504597,
  -0.025354122488923794,
  -0.026792250210734364,
  -0.02501973964524305,
  -0.020169445965834563,
  -0.01304720868695553,
  -0.005024198825863968,
  0.002198574733212953,
  0.006914126086876543,
  0.007761181765381375,
  0.004042781062907539,
  -0.00404188499162899,
  -0.015330864092290097,
  -0.027819039353499816,
  -0.03893097123942304,
  -0.0459528112176902,
  -0.04649584023254638,
  -0.03896504417183149,
  -0.022908514287838785,
  0.0008015322083084683,
  0.030006548699428103,
  0.06152287458791253,
  0.09158515635042258,
  0.11640512243906412,
  0.13275145743495873,
  0.1384547139580855,
  0.13275145743495873,
  0.11640512243906412,
  0.09158515635042258,
  0.06152287458791253,
  0.030006548699428103,
  0.0008015322083084683,
  -0.022908514287838785,
  -0.03896504417183149,
  -0.04649584023254638,
  -0.0459528112176902,
  -0.03893097123942304,
  -0.027819039353499816,
  -0.015330864092290097,
  -0.00404188499162899,
  0.004042781062907539,
  0.007761181765381375,
  0.006914126086876543,
  0.002198574733212953,
  -0.005024198825863968,
  -0.01304720868695553,
  -0.020169445965834563,
  -0.02501973964524305,
  -0.026792250210734364,
  -0.025354122488923794,
  -0.021209081875504597,
  -0.015340390238210138,
  -0.00898922374254505,
  -0.0034023785637388036,
  0.0004293092083268547,
  0.0019363448254255903,
  0.0010122082843755109,
  -0.001937853833798161,
  -0.006187586889156906,
  -0.010801475204181246,
  -0.014858461079284142,
  -0.0176107407498343,
  -0.018612629075524217,
  -0.017776983899015067,
  -0.015357067833173548,
  -0.011866903363934905,
  -0.007962082298390447,
  -0.004307968814918238,
  -0.0014601365677881048,
  0.00022081053185576111,
  0.0006070503306512682,
  -0.00020471254562582804,
  -0.0019441039818904025,
  -0.004239409552378597,
  -0.00669484149235097,
  -0.008960167884861286,
  -0.010773546145437803,
  -0.01198293506324944,
  -0.012536903052289222,
  -0.012458130668497066,
  -0.011811590736777487,
  -0.010668885872912523,
  -0.009094681647916722,
  -0.007135018543169206,
  -0.004829221841616923,
  -0.002225542764886251,
  0.0006009668111083251,
  0.0035310396565683987,
  0.006401142053577143,
  0.009015293138416742,
  0.01116759081169588,
  0.012674208091989657,
  0.013405673947750527,
  0.013311682305199985,
  0.012434291979888126,
  0.010906200637928992,
  0.008929881353988247,
  0.006747189330139785,
  0.0076850586982215585
};
