/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_PROCESS_H
#define QB_PROCESS_H

#include "quadbike.h"
#include "util.h"
#include "source.h"

// number of consecutive one-bits until we decide that we
// have a leader tone
#define QB_LEADER_TONE_NUM_ONES          256 

qb_err_t qb_process_main (qb_t *qb, int argc, char **argv2);
u16_t qb_get_phase_for_phase_ix (s8_t ix);
char qb_get_char_for_phase_ix (s8_t p);




#endif // QB_PROCESS_H
