/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_POLARITY_H
#define QB_POLARITY_H

#include "qb_types.h"
#include "span2.h"

qb_err_t qb_spans_scan_polarities (qb_span_t *spans,
                                   s32_t num_spans,
                                   u8_t *at_least_one_inversion_required_out,
                                   u8_t setup_phase,
                                   u8_t verbose);
                               
qb_err_t qb_correct_polarities (qb_span_t *spans,
                                s32_t num_spans,
                                s32_t rate,
                                s64_t total_input_len,
                                u8_t verbose);

#endif // QB_POLARITY_H
