/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_PLL_H
#define QB_PLL_H

#include "quadbike.h"
#include "fir.h"
#include "process.h"

typedef struct qb_pll_filter_s {
  u8_t type;
  // state
  double a0, a1, a2, b0, b1, b2, x1, x2, y1, y2; // still doubles
} qb_pll_filter_t;

typedef struct qb_pll {
  
  // configuration
  float sample_rate;
  double pll_cf;
  double loop_gain;
  //float pll_cf;
  //float loop_gain;
  //float lock_thresh;
  double lock_thresh;

  // state
  qb_pll_filter_t loop_filter;
  qb_pll_filter_t lock_filter;
  //float pll_integral;
  //float ref_sig;
  //float old_ref;
  //float pll_lock;
  double pll_integral;
  double ref_sig;
  double old_ref;
  double pll_lock;
  u8_t locked;

  // results
  s32_t samples_processed;
  u32_t num_locks;
  double max_lock_value;
  double time_locked;
  //float max_lock_value;
  //float time_locked;
  float tape_speed;
  
  // debugging extras
  double debug_quad_ref;
  //float debug_quad_ref;

} qb_pll_t;

typedef struct qb_pll_carrier_s {
  //double *signal;
  float *signal;
} qb_pll_carrier_t;

float qb_pll_process(qb_pll_t *pll, double in);

void qb_pll_init(qb_pll_t *pll,
                 s32_t sample_rate,
                 double loop_cutoff_hz,
                 double lock_cutoff_hz,
                 double loop_gain,
                 double pll_cf, // centre frequency (Hz)
                 double lock_thresh);

double qb_pll_get_tape_speed(qb_pll_t *pll);

void qb_pll_populate_inspect_values_slice (qb_pll_t *pll, s16_t pll_inspect[4]);

#endif // QB_PLL_H
