/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_ERRCORR_H
#define QB_ERRCORR_H

#include "quadbike.h"
#include "atom.h"

#define QB_ERRCORR_NONE            0 
#define QB_ERRCORR_SINGLETON_WINS  1 // singletons force adjacent bitflip
#define QB_ERRCORR_CONFIDENCE_WINS 2 // confidence basis
#define QB_ERRCORR_ZERO_WINS       3 // force 1 -> 0 always
#define QB_ERRCORR_ONE_WINS        4 // force 0 -> 1 always
#define QB_ERRCORR_EARLY_WINS      5 // earlier cycle wins (latter is flipped)
#define QB_ERRCORR_LATE_WINS       6 // later cycle wins (earlier is flipped)

typedef struct qb_cycle_run_s {
  s32_t start_cycs;
  s32_t len_cycs;
  u8_t value;
} qb_cycle_run_t;
                                  
qb_err_t qb_do_atomflip_correction_all_spans (qb_span_t *spans, s32_t num_spans, u8_t strat, u8_t verbose);

#endif // QB_ERRCORR_H
