/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "bp_0k4_3k2_48k.h"

/*

FIR filter designed with
 http://t-filter.engineerjs.com

sampling frequency: 48000 Hz

* 0 Hz - 100 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -41.47353618544277 dB

* 400 Hz - 3200 Hz
  gain = 1
  desired ripple = 6 dB
  actual ripple = 4.329353116583787 dB

* 3600 Hz - 24000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -41.47353618544277 dB

*/


const double qb_fir_taps_bp_0k4_3k2_48k[QB_FIR_TAPS_BP_0K4_3K2_48K] = {
  0.007040328235496521,
  0.006900759471041381,
  0.009464706175899293,
  0.011908966770740053,
  0.01390757626405453,
  0.015140129854750922,
  0.015341649612505427,
  0.014351148484686273,
  0.012148955276776029,
  0.008873808963105058,
  0.004817474707760738,
  0.0003954535711936703,
  -0.003907141201389167,
  -0.007601663884699922,
  -0.010270857392279332,
  -0.011631855095611323,
  -0.011587968993660422,
  -0.01024305754094008,
  -0.007896644684145622,
  -0.004996408001133892,
  -0.0020686404765758613,
  0.0003640872342166917,
  0.0018721679745324492,
  0.0021886510929572307,
  0.0012546593877878892,
  -0.0007662995382338279,
  -0.003516478440537376,
  -0.006508311488022669,
  -0.009207881490630876,
  -0.011132631338931307,
  -0.011940346972599457,
  -0.011494395118641058,
  -0.00989397987319205,
  -0.007459008213702832,
  -0.0046752766863405616,
  -0.0021077716981100676,
  -0.0002969864851413328,
  0.00034799471629384056,
  -0.00037141054044242353,
  -0.0023985295082473847,
  -0.00541936043642174,
  -0.008915697058730562,
  -0.012259070184862044,
  -0.014820484269815573,
  -0.01609660114555672,
  -0.015815095278692237,
  -0.013987711970730385,
  -0.010936636744401275,
  -0.007233964798124802,
  -0.0036145697840585913,
  -0.0008360113490973685,
  0.0004637714348443272,
  -0.00010111489262941584,
  -0.0025762959514673027,
  -0.006635673895354924,
  -0.011619957206863249,
  -0.016641876134832995,
  -0.020739993498243008,
  -0.02306053122573453,
  -0.02302413823317557,
  -0.020473860480196976,
  -0.015707578403477567,
  -0.009514037993661005,
  -0.0029971972417891573,
  0.0025434661681931568,
  0.0058668392550774405,
  0.006036742026889424,
  0.002604917921764668,
  -0.004245791719249856,
  -0.013650678664414927,
  -0.024143883899074122,
  -0.03384535974040167,
  -0.04072027496080255,
  -0.04288884679774651,
  -0.03893887915085087,
  -0.028190465208628137,
  -0.010857605429377672,
  0.011913838927168031,
  0.03814637627394401,
  0.06525085654787054,
  0.09035088340423088,
  0.11066375259195325,
  0.12387487739542173,
  0.1284562715483535,
  0.12387487739542173,
  0.11066375259195325,
  0.09035088340423088,
  0.06525085654787054,
  0.03814637627394401,
  0.011913838927168031,
  -0.010857605429377672,
  -0.028190465208628137,
  -0.03893887915085087,
  -0.04288884679774651,
  -0.04072027496080255,
  -0.03384535974040167,
  -0.024143883899074122,
  -0.013650678664414927,
  -0.004245791719249856,
  0.002604917921764668,
  0.006036742026889424,
  0.0058668392550774405,
  0.0025434661681931568,
  -0.0029971972417891573,
  -0.009514037993661005,
  -0.015707578403477567,
  -0.020473860480196976,
  -0.02302413823317557,
  -0.02306053122573453,
  -0.020739993498243008,
  -0.016641876134832995,
  -0.011619957206863249,
  -0.006635673895354924,
  -0.0025762959514673027,
  -0.00010111489262941584,
  0.0004637714348443272,
  -0.0008360113490973685,
  -0.0036145697840585913,
  -0.007233964798124802,
  -0.010936636744401275,
  -0.013987711970730385,
  -0.015815095278692237,
  -0.01609660114555672,
  -0.014820484269815573,
  -0.012259070184862044,
  -0.008915697058730562,
  -0.00541936043642174,
  -0.0023985295082473847,
  -0.00037141054044242353,
  0.00034799471629384056,
  -0.0002969864851413328,
  -0.0021077716981100676,
  -0.0046752766863405616,
  -0.007459008213702832,
  -0.00989397987319205,
  -0.011494395118641058,
  -0.011940346972599457,
  -0.011132631338931307,
  -0.009207881490630876,
  -0.006508311488022669,
  -0.003516478440537376,
  -0.0007662995382338279,
  0.0012546593877878892,
  0.0021886510929572307,
  0.0018721679745324492,
  0.0003640872342166917,
  -0.0020686404765758613,
  -0.004996408001133892,
  -0.007896644684145622,
  -0.01024305754094008,
  -0.011587968993660422,
  -0.011631855095611323,
  -0.010270857392279332,
  -0.007601663884699922,
  -0.003907141201389167,
  0.0003954535711936703,
  0.004817474707760738,
  0.008873808963105058,
  0.012148955276776029,
  0.014351148484686273,
  0.015341649612505427,
  0.015140129854750922,
  0.01390757626405453,
  0.011908966770740053,
  0.009464706175899293,
  0.006900759471041381,
  0.007040328235496521
};
