/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_GOERTZEL_H
#define QB_GOERTZEL_H

#include "quadbike.h"
#include "process.h"
                        


#if defined QB_VECTORS_GCC_CLANG || defined QB_VECTORS_MSVC_AVX2
qb_err_t qb_goertzel_oversample_vector_new (qb_vec_buf_t *vbuf,
                                            s32_t winlen,
                                            qb_vec_f_t *two_cos_omega_0_vec,
                                            qb_vec_f_t *two_cos_omega_1_vec,
                                            qb_vec_f_t *scaler_for_2400_power_vec,
                                            float *max_power0_out,
                                            float *max_power1_out,
                                            float *max_powerX_out,
                                            float *max_confidence_out,
                                            qb_vec_buf_t oversampled_vec[2], // [0], [1] are allocated here
                                            u8_t display_progress);

qb_err_t qb_goertzel_pwr_vector_new (qb_vec_f_t *vin,
                                     s64_t sequence_len,
                                     qb_vec_f_t *zeros, // so stupid
                                     qb_vec_f_t *two_cos_omega_vec,
                                     qb_vec_f_t *power_out_vec);

#else // no vectors
qb_err_t qb_goertzel_oversample(float *src_f,
  s64_t srclen,
  s32_t winlen,
  float omega0, // 1200 Hz in rads/sample
  float omega1, // 2400 Hz in rads/sample
  float scaler_for_2400_power,
  float *max_power0_out,
  float *max_power1_out,
  float *max_powerX_out,
  float *max_confidence_out,
  float *oversamples[2],
  u8_t display_progress);
#endif
                                           
// potentially now used by process.c to do speed measurement
// (qb_compute_speed_by_goertzel)
qb_err_t qb_goertzel_pwr (float *in,
                          s64_t sequence_len,
                          float omega_rads_per_sample,
                          float *power_out);

//void qb_compute_omegas (double tape_speed,
void qb_compute_omegas (float tape_speed,
                        u32_t sample_rate,
                        float *omega_1200_out,
                        float *omega_2400_out);

//void qb_compute_window_lengths (double tape_speed,
void qb_compute_window_lengths (float tape_speed,
                                s32_t sample_rate,
                                u32_t *winlen_out);

#endif // QB_GOERTZEL_H
