/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_FEATURE_H
#define QB_FEATURE_H

#include "qb_types.h"

#define QB_SYNC_WALK_FEATURES_NONE        0
#define QB_SYNC_WALK_FEATURE_MAXIMUM      4
#define QB_SYNC_WALK_FEATURE_MINIMUM      8

#define QB_SYNC_WALK_FEATURES_ALL         0xff

typedef struct qb_wave_feature_s {
  u8_t value;
  s64_t sample_num;
  double amplitude;
} qb_wave_feature_t;

#endif // QB_FEATURE_H
