/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "bp_2k4_48k.h"

/*

FIR filter designed with
 http://t-filter.appspot.com

sampling frequency: 48000 Hz

* 0 Hz - 2000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -41.26251013719448 dB

* 2200 Hz - 2600 Hz
  gain = 1
  desired ripple = 12 dB
  actual ripple = 7.386626126714479 dB

* 2800 Hz - 24000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -41.26251013719448 dB

*/

const double qb_fir_taps_bp_2k4_48k[QB_FIR_TAPS_BP_2K4_48K] = {
  -0.002046130017249079,
  0.0035948172583792474,
  0.0022611624766372645,
  0.0017601681505227675,
  0.0015137483990455421,
  0.0012793419969208061,
  0.0009586287463270787,
  0.000528881053256494,
  7.111269264275075e-7,
  -0.0005863928594241337,
  -0.0011763387507254866,
  -0.0017060840681716216,
  -0.0021126345709237358,
  -0.0023367354740208546,
  -0.0023343393630779734,
  -0.002083033721099797,
  -0.0015853587614333665,
  -0.0008703288867815667,
  0.00000575112317106524,
  0.0009638759875000869,
  0.0019084128315194908,
  0.0027366251290686333,
  0.0033500865836040418,
  0.0036659793921114173,
  0.0036259047993853055,
  0.003204673296099963,
  0.0024162179441237237,
  0.0013151579362109304,
  -0.0000063896408837740085,
  -0.0014257495454091304,
  -0.002801180559793608,
  -0.003985604797094111,
  -0.004841773141195791,
  -0.005257737605640204,
  -0.005160869109019591,
  -0.004527681756063249,
  -0.003389462446048394,
  -0.0018326344290439452,
  0.000007007054051151198,
  0.0019559989313573437,
  0.00381923811865069,
  0.0053994875564836575,
  0.006518039573289386,
  0.0070343110017328835,
  0.006862638177315547,
  0.005984523314666859,
  0.004453915847564022,
  0.0023950018401824253,
  -0.000007246502914246284,
  -0.0025234223935889253,
  -0.004901692879588366,
  -0.006892907929393747,
  -0.008276579238403829,
  -0.008885153080431219,
  -0.008623573258340098,
  -0.0074820900908675134,
  -0.005541004316600205,
  -0.002965998208024626,
  0.000005985550966137263,
  0.003088483558399641,
  0.005973082549151374,
  0.00836049493815907,
  0.009991777812404014,
  0.010676262102220018,
  0.010313641431806282,
  0.00890717718006711,
  0.006566421877888255,
  0.0034992710609655013,
  -0.000006204244196722451,
  -0.003609349874027111,
  -0.006950369791556196,
  -0.009686311573165015,
  -0.011526427046744841,
  -0.012263485986259919,
  -0.011796838082155058,
  -0.010145479267659333,
  -0.0074487967817171985,
  -0.003954613761922774,
  0.00000395566207682949,
  0.004039785673907039,
  0.0077502760422776505,
  0.010758318744837455,
  0.01275102888101717,
  0.013512231791544487,
  0.012946572302690456,
  0.011090460011508133,
  0.008110654276755065,
  0.004289470188641096,
  -0.0000026394670493780694,
  -0.0043447495543516785,
  -0.008305080848454162,
  -0.01148428786241143,
  -0.013557535382284712,
  -0.014309645545818284,
  -0.01365610426963236,
  -0.011654190227282172,
  -0.008493536874949617,
  -0.004477433572639835,
  0.0000019263360434871054,
  0.004494236139004536,
  0.008556921272976059,
  0.011789835128613485,
  0.013874398547275677,
  0.014579645292644116,
  0.013874398547275677,
  0.011789835128613485,
  0.008556921272976059,
  0.004494236139004536,
  0.0000019263360434871054,
  -0.004477433572639835,
  -0.008493536874949617,
  -0.011654190227282172,
  -0.01365610426963236,
  -0.014309645545818284,
  -0.013557535382284712,
  -0.01148428786241143,
  -0.008305080848454162,
  -0.0043447495543516785,
  -0.0000026394670493780694,
  0.004289470188641096,
  0.008110654276755065,
  0.011090460011508133,
  0.012946572302690456,
  0.013512231791544487,
  0.01275102888101717,
  0.010758318744837455,
  0.0077502760422776505,
  0.004039785673907039,
  0.00000395566207682949,
  -0.003954613761922774,
  -0.0074487967817171985,
  -0.010145479267659333,
  -0.011796838082155058,
  -0.012263485986259919,
  -0.011526427046744841,
  -0.009686311573165015,
  -0.006950369791556196,
  -0.003609349874027111,
  -0.000006204244196722451,
  0.0034992710609655013,
  0.006566421877888255,
  0.00890717718006711,
  0.010313641431806282,
  0.010676262102220018,
  0.009991777812404014,
  0.00836049493815907,
  0.005973082549151374,
  0.003088483558399641,
  0.000005985550966137263,
  -0.002965998208024626,
  -0.005541004316600205,
  -0.0074820900908675134,
  -0.008623573258340098,
  -0.008885153080431219,
  -0.008276579238403829,
  -0.006892907929393747,
  -0.004901692879588366,
  -0.0025234223935889253,
  -0.000007246502914246284,
  0.0023950018401824253,
  0.004453915847564022,
  0.005984523314666859,
  0.006862638177315547,
  0.0070343110017328835,
  0.006518039573289386,
  0.0053994875564836575,
  0.00381923811865069,
  0.0019559989313573437,
  0.000007007054051151198,
  -0.0018326344290439452,
  -0.003389462446048394,
  -0.004527681756063249,
  -0.005160869109019591,
  -0.005257737605640204,
  -0.004841773141195791,
  -0.003985604797094111,
  -0.002801180559793608,
  -0.0014257495454091304,
  -0.0000063896408837740085,
  0.0013151579362109304,
  0.0024162179441237237,
  0.003204673296099963,
  0.0036259047993853055,
  0.0036659793921114173,
  0.0033500865836040418,
  0.0027366251290686333,
  0.0019084128315194908,
  0.0009638759875000869,
  0.00000575112317106524,
  -0.0008703288867815667,
  -0.0015853587614333665,
  -0.002083033721099797,
  -0.0023343393630779734,
  -0.0023367354740208546,
  -0.0021126345709237358,
  -0.0017060840681716216,
  -0.0011763387507254866,
  -0.0005863928594241337,
  7.111269264275075e-7,
  0.000528881053256494,
  0.0009586287463270787,
  0.0012793419969208061,
  0.0015137483990455421,
  0.0017601681505227675,
  0.0022611624766372645,
  0.0035948172583792474,
  -0.002046130017249079
};
