/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_SOURCE_H
#define QB_SOURCE_H

#include "build.h"

#include "qb_types.h"
#include "quadbike.h"
#include "atom2.h"
#include "span.h"
#include "vector.h"

typedef struct qb_pcm_s {

  u8_t bytewidth;
  u32_t rate;
  u8_t channels;
  u8_t is_signed;
  u8_t is_big_endian;
  u8_t is_float;
  
//#warning qb_pcm_t still contains both linear buffer and vector buffer

  float *buf;
#if defined QB_VECTORS_GCC_CLANG || defined QB_VECTORS_MSVC_AVX2
  qb_vec_buf_t vbuf;
#endif
  
  s64_t buflen;
  
} qb_pcm_t;


typedef struct qb_source_s {
  qb_pcm_t pcm;
  //double *goertzel_oversampled_p0;
  //double *goertzel_oversampled_p1;
  float *goertzel_oversampled_p0;
  float *goertzel_oversampled_p1;
  s64_t len_smps;                // for the oversamples
  qb_span_t *spans;
  s32_t num_spans;
  u8_t right_channel;
  //double max_confidence;
  //double max_powerX;
  //double tape_speed;
  float max_confidence;
  float max_powerX;
  float tape_speed;
} qb_source_t;
                                           
void qb_finish_pcm (qb_pcm_t *pcm);

char qb_get_channel_char (s16_t c) ;

void qb_print_channel_selection (s16_t c);

void qb_finish_source (qb_source_t *src);

#endif // QB_SOURCE_H
