/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "source.h"
#include "util.h"
#include "vector.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


void qb_finish_pcm (qb_pcm_t *pcm) {
  if (NULL != pcm) {
    if (NULL != pcm->buf) {
      qb_free(pcm->buf);
    }
#if defined QB_VECTORS_GCC_CLANG || defined QB_VECTORS_MSVC_AVX2
    if (QB_VECTYPE_FLOAT == pcm->vbuf.type) {
      qb_free(pcm->vbuf.v.f);
    }
    //if (QB_VECTYPE_DOUBLE == pcm->vbuf.type) {
    //  qb_free(pcm->vbuf.v.d);
    //}
#endif
    memset(pcm, 0, sizeof(qb_pcm_t));
  }
}

void qb_print_channel_selection (s16_t c) {
  printf("Channel: %c\n", qb_get_channel_char(c));
}


char qb_get_channel_char (s16_t c) {
  u8_t d;
  d = '?';
  if (0 == c) { d = 'L'; }
  if (1 == c) { d = 'R'; }
  return d;
}


void qb_finish_source (qb_source_t *src) {
  s32_t sn;
  qb_finish_pcm(&(src->pcm));
  if (NULL != src->spans) {
    for (sn=0; sn < src->num_spans; sn++) {
      qb_span_finish (src->spans + sn);
    }
    qb_free(src->spans);
    src->spans = NULL;
  }
  if (NULL != src->goertzel_oversampled_p0) {
    qb_free(src->goertzel_oversampled_p0);
    src->goertzel_oversampled_p0 = NULL;
  }
  if (NULL != src->goertzel_oversampled_p1) {
    qb_free(src->goertzel_oversampled_p1);
    src->goertzel_oversampled_p1 = NULL;
  }
}
