/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_QBIO_H
#define QB_QBIO_H

#include "quadbike.h"
#include "atom2.h"

#include <stdio.h>



typedef struct qb_stat {
  u8_t is_dir;
  u8_t is_link;
  u64_t fsize;
} qb_stat_t;

// FIXME: pass in filename for errmsg
qb_err_t qb_fread_fully(u8_t *buf, size_t size, FILE *f);
     
     /*
qb_err_t qb_load (char *filename,
                  u8_t *buf,
                  s32_t bufsize,
                  s32_t *actual_len_out); */
               
qb_err_t qb_write_file (char *filename, u8_t overwrite,
                        u8_t *payload, size_t len) ;

//qb_err_t qb_fwrite_fully (u8_t *buf,
//                          size_t size,
//                          char *filename_for_printing,
//                          FILE *f);
                      
qb_err_t qb_read_file (char *filename,
                       u8_t **payload_out,
                       s64_t *len_out,
                       s64_t max_size);
                       
qb_err_t qb_check_can_write_file (char *filename, u8_t overwrite);
                       
qb_err_t qb_stat_file (char *filename, qb_stat_t *stat_out);

FILE *qb_fopen (char *filename, char *mode) ;
                         
qb_err_t qb_fwrite_fully (u8_t *buf,
                          size_t size,
                          char *filename,
                          FILE *f);


#endif // QB_QBIO_H
