#ifndef WORLD_H
#define WORLD_H

#define WORLD_NUM_PXPAIRS     16
#define WORLD_NUM_ANIMSPEEDS  16
#define WORLD_NUM_FLASKS      16
#define NUM_CRYSTALS          5
#define WORLD_NUM_LOW_FLASKS  10

#define WORLD_GLOBAL_ROOM_TBL_LEN 256

#include "krunpack.h"

typedef struct world_data {

  u8_t pixel_base_pairs[WORLD_NUM_PXPAIRS];
  u8_t animation_speeds[WORLD_NUM_ANIMSPEEDS];
  u8_t flasks_room_ids[WORLD_NUM_FLASKS];
  u8_t flasks_positions[WORLD_NUM_FLASKS];
  u8_t room_name_page[WORLD_GLOBAL_ROOM_TBL_LEN];
  
} world_data_t;

void world_init(world_data_t *world);

#endif // WORLD_H
