#ifndef TRIANGLE_H
#define TRIANGLE_H

#include "krunpack.h"
#include "roomdata.h"
#include "vram.h"
#include "raster.h"

#define MAX_TRIANGLES 7

typedef struct low_res_triangle_point {
  // need 16-bit negative range
  s16_t x;
  s16_t y;
} low_res_triangle_point_t;

typedef struct high_res_triangle_point {
  u8_t x_low;  // low byte
  u8_t x_high; // high byte
  u8_t y_low;  // low byte
  u8_t y_high; // high byte
} high_res_triangle_point_t;

typedef struct triangle {
  low_res_triangle_point_t v1;
  low_res_triangle_point_t v2;
  high_res_triangle_point_t v3_tmp;
  low_res_triangle_point_t v3;
  s8_t fg_plot_mode;
  s16_t fg_colour;
} triangle_t;

citerr_t triangle_fix_coords (triangle_t *t);
void triangle_init (triangle_t *t);
void propagate_triangle_colours_and_plot_modes (triangle_t triangles[MAX_TRIANGLES],
                                                s8_t num_triangles);

#define SCRATCH_TRGL_BUF_MARGIN 32
#define SCRATCH_TRGL_BUF_HEIGHT (FRAMEBUF_HEIGHT + SCRATCH_TRGL_BUF_MARGIN) // 224

citerr_t bresenham(s16_t v1x,
                   s16_t v1y,
                   s16_t v2x,
                   s16_t v2y,
                   //vram_t *vram, // NULL means no drawing; spans only
                   u8_t spans_only,
                   u8_t buf[SCRATCH_TRGL_BUF_HEIGHT * FRAMEBUF_WIDTH],
                   raster_span_t **spans_out,
                   u32_t *num_spans_out,
                   u32_t *alloced_spans_out);

#endif
