#ifndef ROOMDATA_H
#define ROOMDATA_H

#include "krunpack.h"

typedef struct room_data {
  u8_t *buf;
  u16_t len;
  u16_t pos;
} room_data_t;

typedef struct room_id {
  s16_t original;
  s16_t redirected;
} room_id_t;

s16_t    room_id_fetch          (room_id_t *rid);
void     room_id_init           (room_id_t *rid);

citerr_t room_data_rewind       (room_data_t *roomdata);
void     room_data_reset        (room_data_t *roomdata);
citerr_t room_data_advance      (room_data_t *roomdata, u8_t distance);
citerr_t room_data_inbounds     (room_data_t *roomdata);
citerr_t room_data_ext_inbounds (room_data_t *roomdata, u16_t pos);
citerr_t room_data_read         (room_data_t *roomdata, u8_t *out);
citerr_t room_data_extread      (room_data_t *roomdata, u16_t pos, u8_t *out);
void     room_data_init         (room_data_t *roomdata,
                                 u8_t *buf,
                                 u16_t buflen);

#endif // ROOMDATA_H
