
#ifndef PARSE_H
#define PARSE_H

#include "krunpack.h"
#include "roomdata.h"
#include "citconf.h"
#include "vram.h"
#include "tiledata.h"

citerr_t parse_room (s16_t room_id,
                     room_data_t *roomd,
                     tile_data_t *tiledata,
                     citadel_config_t *config,
                     world_data_t *world,
                     s16_t *flask_x_out,
                     s16_t *flask_y_out,
                     vram_t *vram,
                     s16_t *sm_tactile_x_out,
                     s16_t *sm_tactile_y_out);
u16_t coords_to_vram_ptr (u8_t x, u8_t y);
u16_t coords_to_vram_ptr_with_carry (u8_t _x, u8_t _y, u8_t *carry_out);
u8_t add_with_carry (u8_t a, u8_t b, u8_t *carry_inout);

#endif
