#ifndef CRUNPACK_H
#define CRUNPACK_H

#include "citerr.h"

#define DEBUG_ENABLE_RECTANGLES 1
#define CITADEL_TRACE_1 0
#define CITADEL_TRACE_2 0
#define CITADEL_TRACE_3 0
  
//#define CITADEL_USE_EXCEPTIONS 1
  
#define CIT_VERSION  "krunpack, Citadel room renderer (C version), 'Diminished', 0.1, 21st Dec 2025"

#define DOORS_LOCKED                   0
#define DOORS_UNLOCKED                 1
#define DOORS_OPENED                   2
  
#define CITAM_LEN                      16640
#define CITAX_LEN                      17920

  // significant room IDs
#define RID_WELL                       0xad
#define RID_48                         0x48
#define RID_WELL_WHEEL                 0x71
#define RID_WEST_WING_SWITCH_MONK      0x80
#define RID_19_TELEPORTER              0x19
#define RID_STAR_PORT_DISH_ALIEN       5
 
//#define ROOM_DATA_MAGIC \x07\x80\x18\x08
  // player data starts  "\x10\x38\x60\x88"
//#define TILE_DATA_MAGIC \x23\x00\x00\x06
//#define ANIM_DATA_MAGIC \x10\x38\x60\x88

#define PRE_TILE_DATA_MAGIC ((u8_t *) "\x04\x1f\x05\x11") // part of the reprogramming text
#define L_PRE_TILE_DATA_MAGIC 4

#define PRE_ROOM_DATA_MAGIC ((u8_t *) "\x20\x00\xe3\x5e\x00\x00\x00\x00" \
                                      "\x00\x00\x00\x00\x00\x00\x00\x00" \
                                      "\x00\x00\x00\x00\x00\x00\x00\x00")
#define L_PRE_ROOM_DATA_MAGIC 24
                            
#define POST_GLOBAL_ROOMNAMES_MAGIC ((u8_t *) "\xee\x20\x01\x60\x84\x01\x86\x00")
#define L_POST_GLOBAL_ROOMNAMES_MAGIC 8
  
  // this, then T_BASE_PIXEL_PAIRS, then T_ANIM_SPEEDS_MASTER:
#define PRE_PXPAIRS_ANIMSPEEDS_MAGIC ((u8_t *) "\x3a\x26\x39\x26\x38\xa5\x38\x60")
#define L_PRE_PXPAIRS_ANIMSPEEDS_MAGIC 8

typedef unsigned long long u64_t;
typedef signed long long s64_t;
typedef unsigned int u32_t;
typedef signed int s32_t;
typedef unsigned short u16_t;
typedef signed short s16_t;
typedef unsigned char u8_t;
typedef signed char s8_t;

typedef int citerr_t;

#define CIT_SSCANF sscanf

#ifdef _WIN32
#define DOZE_STRERROR_LEN 80
#endif

#define CAN_ADD_U64(a,b) ( !(((a)|(b))&0x8000000000000000) || ((((a)^(b))&0x8000000000000000) && !(((0x7fffffffffffffff & (a)) + (0x7fffffffffffffff & (b))) & 0x8000000000000000)) )
                          // ^ FAIL if both hibits set         ^ WIN if both hibits clear, but if different, ^ result depends on whether there is anything carried into top bit
#define CAN_ADD_U32(a,b) ( !(((a)|(b))&0x80000000) || ((((a)^(b))&0x80000000) && !(((0x7fffffff & (a)) + (0x7fffffff & (b))) & 0x80000000)) )
#define CAN_ADD_SZT(a,b) ((sizeof(size_t)==8) ? (CAN_ADD_U64((a),(b))) : (CAN_ADD_U32((a),(b))))

u16_t to_16bit (u8_t hi, u8_t lo);

#endif // CRUNPACK_H

