#ifndef CITPNG_H
#define CITPNG_H

#include "krunpack.h"
#include <stdio.h>

#define CIT_PNG_MIN_WIDTH    1U
#define CIT_PNG_MAX_LOAD_WIDTH    3840U // 4K
#define CIT_PNG_MIN_HEIGHT   1U
#define CIT_PNG_MAX_LOAD_HEIGHT   3840U // 4K

#define CIT_PNG_MAX_SAVE_WIDTH  10000
#define CIT_PNG_MAX_SAVE_HEIGHT 10000

#define CIT_PNG_NUM_ID_BYTES 8

#define CIT_PNG_SRC_TYPE_RGB24  1
#define CIT_PNG_SRC_TYPE_RGBA32 2

typedef struct cit_png_membuf {
  u8_t *buf;
  size_t pos;
  size_t alloc; // only used for writing
} cit_png_membuf_t;

citerr_t cit_save_png (u8_t *bitmap8,
                       s32_t width, s32_t height,
                       char *path,
                       u8_t source_type, // CIT_PNG_SRC_TYPE_*
                       u8_t allow_overwrite,
                       size_t *filesize_out,
                       s32_t bitmap_stride_bytes) ;

#endif
