#!/bin/bash


OPDIR="citadel-pngs"
CITAM="CITAX"
BIN="./krunpack"

ROOMS="1 5 6 11 \
      `seq -s ' ' 21 29` 33 34 35 \
      41 47 48 49 53 54 55 \
      61 `seq -s ' ' 67 75` \
      `seq -s ' ' 87 95` \
      `seq -s ' ' 100 115` \
      120 121 `seq -s ' ' 128 139` \
      140 144 145 146 `seq -s ' ' 148 151` 153 156 157 158 \
      163 164 166 169 173 \
      `seq -s ' ' 181 184` `seq -s ' ' 192 196` \
      `seq -s ' ' 201 206` 208 213 214 \
      226 227 228 `seq -s ' ' 234 239`"

COLLISION_TOO=0
CRY="+cr 01234"
XS="" #"+xs"

mkdir "${OPDIR}"
rm "${OPDIR}"/*.png

# place correct items in rooms:

for R in $ROOMS ; do
  IT=""
  case $R in
      "1") IT="+it 28"  ;; # pyramid 2, cyan bone
      "5") IT="+it 79"  ;; # star port dish alien, red/white key
     "11") IT="+it 1"   ;; # central tower secret, yellow/white crystal
     "23") IT="+it 36"  ;; # alien temple; alien figurine
     "28") IT="+it 27"  ;; # west tower; skull
     "41") IT="+it 30"  ;; # pyramid 4; blue stone slab
     "54") IT="+it 75"  ;; # east tower; green/cyan key
     "88") IT="+it 58"  ;; # double monk; trampo
     "90") IT="+it 30"  ;; # kitchen; blue stone slab
     "92") IT="+it 20"  ;; # west wing; gunpowder
     "94") IT="+it 29"  ;; # east wing; pink bone
    "104") IT="+it 73"  ;; # witch house external; green/yellow key
    "108") IT="+it 76"  ;; # west wing gateway; white/cyan freezer key
    "110") IT="+it 21"  ;; # Freezer; chicken
    "111") IT="+it 0"   ;; # off Freezer; pink/red crystal
    "114") IT="+it 60"  ;; # off Prison; Egyptian mask
    "129") IT="+it 74"  ;; # central castle; red/yellow key
    "130") IT="+it 24"  ;; # central castle; barrel
    "131") IT="+it 30"  ;; # Main Hall; blue stone slab
    "132") IT="+it 72"  ;; # C. Castle; pink/white key
    "133") IT="+it 9"   ;; # Well, bucket
    "135") IT="+it 77"  ;; # Beach; pink/red key
    "144") IT="+it 33"  ;; # Witch House secret; yellow/pink crown
    "148") IT="+it 34"  ;; # Well; green/yellow crown
    "149") IT="+it 78"  ;; # Cellar; blue/cyan key
    "151") IT="+it 14"  ;; # Cellar; ice crystal
    "163") IT="+it 30"  ;; # Star port dish; blue stone slab
    "166") IT="+it 3"   ;; # Witch House basement; green/cyan crystal
    "196") IT="+it 4"   ;; # Lab; yellow/green crystal
    "203") IT="+it 58"  ;; # Temple; trampo
    "214") IT="+it 35"  ;; # Well; Red/magenta crown
    "228") IT="+it 17"  ;; # Far Island; Egyptian statue
  esac
  if [ $COLLISION_TOO == 1 ] ; then
    echo "${BIN}" $IT $XS $CRY "${CITAM}" $R "${OPDIR}"/"${R}".png "${OPDIR}"/"${R}C".png
    if ! "${BIN}" $IT $XS $CRY "${CITAM}" $R "${OPDIR}"/"${R}".png "${OPDIR}"/"${R}C".png ; then
      exit
    fi
  else
    echo "${BIN}" $IT $XS $CRY "${CITAM}" $R "${OPDIR}"/"${R}".png
    if ! "${BIN}" $IT $XS $CRY "${CITAM}" $R "${OPDIR}"/"${R}".png ; then
      exit
    fi
  fi
done


